* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Import BEA data on GDP, consumption, and investment
* "Table 1.1.5. Gross Domestic Product"
* "[Billions of dollars]" 
* "Bureau of Economic Analysis" 
* Annual
import delimited "$datapath/BEA_quantities.csv", clear 
ren *year year 
tsset year 
compress
save BEA_quantities, replace

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Import price deflators from BEA
* Table 1.1.9. Implicit Price Deflators for Gross Domestic Product
* [Index numbers, 2012=100]
* Bureau of Economic Analysis
* Annual
import delimited "$datapath/BEA_prices.csv", clear 
ren *year year 
tsset year
compress
save BEA_prices, replace


* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Import total hours worked
* Source: Nonfarm Business Sector: Hours of All Persons
* FRED/BLS
import fred HOANBS, aggregate(annual) clear
tsmktim year, start(1947)
drop date*
ren H N 
compress
save hours.dta, replace

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Download Civilian Noninstitutional Population 16+ years
import fred CNP16OV, aggregate(annual) clear
tsmktim year, start(1948)
drop date*
ren CN POP
save POP.dta, replace

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Merge all the data together
use BEA_quantities, clear
merge 1:1 year using BEA_prices, keep(3) nogen
merge 1:1 year using POP, keep(3) nogen
merge 1:1 year using hours, keep(3) nogen

* Deflate
local varlist gdp c i 
foreach x of local varlist{
	replace `x' = `x'/ p_`x' * 100
}
drop p_*

* Define in per-capita terms
local varlist gdp c i
foreach x of local varlist{
	replace `x' = `x' / POP
}

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Construct the aggregate capital stock
* Annual depreciation
scalar DELTA = .10
* Assume capital and output grow at the same rate
* This is used for the initial level of K
gen g_y = log(gdp) - log(l.gdp)
gen gy = 1/3*g_y + 1/3*g_y[_n-1] + 1/3*g_y[_n-2]
su gy
scalar g_k = r(mean)
gen K = i/(DELTA + g_k) in 1
drop g_y gy
replace K = (1-DELTA)*l.K + l.i if year>1948
lab var K "Capital Stock"

* Take logs
local varlist gdp c i N K
foreach x of local varlist{
	qui g l`x' = log(`x')
}

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Construct the Solow residual
scalar ALPHA = 1/3
gen SR = lgdp - ALPHA*lK - (1-ALPHA)*lN
lab var SR "Log Solow residual"

* HP-filtering
tsfilter hp GDP_hp = lgdp
tsfilter hp C_hp = lc
tsfilter hp I_hp = li
tsfilter hp SR_hp = SR

keep year *hp

compress
save "$datapath/RBC_data.dta", replace
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

erase POP.dta
erase hours.dta
erase BEA_prices.dta
erase BEA_quantities.dta

